//+------------------------------------------------------------------+
//|                                              C_TimesAndTrade.mqh |
//|                                                      Daniel Jose |
//|                                                                  |
//+------------------------------------------------------------------+
#property copyright "Daniel Jose"
//+------------------------------------------------------------------+
#include <NanoEA-SIMD\Auxiliar\C_FnSubWin.mqh>
//+------------------------------------------------------------------+
class C_TimesAndTrade : private C_FnSubWin
{
//+------------------------------------------------------------------+
#define def_SizeBuff 4096
#define macro_Limits(A) (A & 0xFF)
#define def_FLAG_DIRECT (TICK_FLAG_BUY | TICK_FLAG_SELL)
//+------------------------------------------------------------------+
	private	:
		string	m_szCustomSymbol,
					m_szObjName;
		char		m_ConnectionStatus;
		datetime	m_LastTime;
		ulong		m_MemTickTime;
//+------------------------------------------------------------------+
inline void CreateCustomSymbol(void)
			{
				m_szCustomSymbol = "_" + Terminal.GetFullSymbol();
				SymbolSelect(Terminal.GetFullSymbol(), true);
				SymbolSelect(m_szCustomSymbol, false);
				CustomSymbolDelete(m_szCustomSymbol);
				CustomSymbolCreate(m_szCustomSymbol, StringFormat("Custom\\Robot\\%s", m_szCustomSymbol), Terminal.GetFullSymbol());
				CustomRatesDelete(m_szCustomSymbol, 0, LONG_MAX);
				CustomTicksDelete(m_szCustomSymbol, 0, LONG_MAX);
				SymbolSelect(m_szCustomSymbol, true);
			};
//+------------------------------------------------------------------+
inline void CreateChart(void)
			{
#define macro_SetInteger(A, B) ObjectSetInteger(Terminal.Get_ID(), m_szObjName, A, B)
				long handle;				
				m_szObjName = (string)ObjectsTotal(Terminal.Get_ID(), -1, -1) + (string)MathRand();
				ObjectCreate(Terminal.Get_ID(), m_szObjName, OBJ_CHART, GetIdSubWinEA("Time&TradeSupport"), 0, 0);
				ObjectSetString(Terminal.Get_ID(), m_szObjName, OBJPROP_SYMBOL, m_szCustomSymbol);
				macro_SetInteger(OBJPROP_CORNER, CORNER_LEFT_UPPER);
				macro_SetInteger(OBJPROP_XDISTANCE, 0);
				macro_SetInteger(OBJPROP_YDISTANCE, 0);
				macro_SetInteger(OBJPROP_XSIZE, ChartGetInteger(Terminal.Get_ID(), CHART_WIDTH_IN_PIXELS, GetIdSubWinEA()));
				macro_SetInteger(OBJPROP_YSIZE, ChartGetInteger(Terminal.Get_ID(), CHART_HEIGHT_IN_PIXELS, GetIdSubWinEA()));
				macro_SetInteger(OBJPROP_DATE_SCALE, false);
				macro_SetInteger(OBJPROP_PRICE_SCALE, false);
				macro_SetInteger(OBJPROP_PERIOD, PERIOD_M1);
				handle = ObjectGetInteger(Terminal.Get_ID(), m_szObjName, OBJPROP_CHART_ID);
				ChartApplyTemplate(handle, "Times&Trade.tpl");
				ChartRedraw(handle);				
#undef macro_SetInteger
			};
//+------------------------------------------------------------------+
	public	:
//+------------------------------------------------------------------+
		C_TimesAndTrade() : m_ConnectionStatus(-1)
			{
				m_szCustomSymbol = NULL;
			}
//+------------------------------------------------------------------+
		~C_TimesAndTrade()
			{
				SymbolSelect(m_szCustomSymbol, false);
				CustomSymbolDelete(m_szCustomSymbol);
			}
//+------------------------------------------------------------------+
		void Init(const int iScale = 2)
			{
				if (!ExistSubWin())
				{
					CreateCustomSymbol();
					CreateChart();
					m_ConnectionStatus = 0;
				}
				ObjectSetInteger(Terminal.Get_ID(), m_szObjName, OBJPROP_CHART_SCALE, (iScale > 5 ? 5 : (iScale < 0 ? 0 : iScale)));
			}
//+------------------------------------------------------------------+
inline void Connect(void)
			{
				switch (m_ConnectionStatus)
				{
					case 0:
						if (!TerminalInfoInteger(TERMINAL_CONNECTED)) return; else m_ConnectionStatus = 1;
					case 1:
						if (!SymbolIsSynchronized(Terminal.GetFullSymbol())) return; else m_ConnectionStatus = 2;
					case 2:
						m_LastTime = TimeLocal();
						m_MemTickTime = macroMinusMinutes(60, m_LastTime) * 1000;
						m_ConnectionStatus = 3;
					default:
						break;
				}
			}	
//+------------------------------------------------------------------+
inline void Update(void)
			{
				MqlTick Tick[];
				MqlRates Rates[def_SizeBuff];
				int i0, p1, p2 = 0;
				int iflag;

				if (m_ConnectionStatus < 3) return;
				if ((i0 = CopyTicks(Terminal.GetFullSymbol(), Tick, COPY_TICKS_ALL, m_MemTickTime, def_SizeBuff)) > 0)
				{
					for (p1 = 0, p2 = 0; (p1 < i0) && (Tick[p1].time_msc == m_MemTickTime); p1++);
					for (int c0 = p1, c1 = 0; c0 < i0; c0++)
					{
						if (Tick[c0].volume == 0) continue;
						iflag = 0;
						iflag += ((Tick[c0].flags & TICK_FLAG_BUY) == TICK_FLAG_BUY ? 1 : 0);
						iflag -= ((Tick[c0].flags & TICK_FLAG_SELL) == TICK_FLAG_SELL ? 1 : 0);
						if (iflag == 0) continue;
						Rates[c1].high = Tick[c0].ask;
						Rates[c1].low = Tick[c0].bid;
						Rates[c1].open = Tick[c0].last;
						Rates[c1].close = Tick[c0].last + ((Tick[c0].volume > 200 ? 200 : Tick[c0].volume) * (Terminal.GetTypeSymbol() == C_Terminal::WDO ? 0.02 : 1.0) * iflag);
						Rates[c1].time = m_LastTime;
						p2++;
						c1++;
						m_LastTime += 60;
					}
					CustomRatesUpdate(m_szCustomSymbol, Rates, p2);
					m_MemTickTime = Tick[i0 - 1].time_msc;
				}
			}
//+------------------------------------------------------------------+
		void Resize(void)
			{
				static int MaxX = 0;
				int x = (int) ChartGetInteger(Terminal.Get_ID(), CHART_WIDTH_IN_PIXELS, GetIdSubWinEA()), y;
	
				y = (int) ChartGetInteger(Terminal.Get_ID(), CHART_HEIGHT_IN_PIXELS, GetIdSubWinEA());
				ObjectSetInteger(Terminal.Get_ID(), m_szObjName, OBJPROP_YSIZE, y);
				if (MaxX != x)
				{
					MaxX = x;
	  				ObjectSetInteger(Terminal.Get_ID(), m_szObjName, OBJPROP_XSIZE, x);
				}
			}
//+------------------------------------------------------------------+
#undef def_SizeBuff
#undef macro_Limits
#undef def_FLAG_DIRECT
};
//+------------------------------------------------------------------+
